<?xml version="1.0" encoding="UTF-8"?><!--
            Copyright
            2010 axYus - http://www.axyus.com
            2010 J.Leger - johann.leger@axyus.com

            This file is part of ODM print-comp.

            ODM print-comp is free software; you can redistribute it and/or modify
            it under the terms of the GNU Lesser General Public License as published by
            the Free Software Foundation; either version 2 of the License, or
            (at your option) any later version.

            ODM print-comp is distributed in the hope that it will be useful,
            but WITHOUT ANY WARRANTY; without even the implied warranty of
            MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
            GNU Lesser General Public License for more details.

            You should have received a copy of the GNU Lesser General Public License
            along with ODM print-comp; if not, write to the Free Software
            Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
        --><xsl:stylesheet xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:n="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:xad="http://uri.etsi.org/01903/v1.2.2#" xmlns:data="http://odm-budgetaire.org/data" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:date="http://exslt.org/dates-and-times" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:com="http://www.xemelios.org/namespaces#cg-1.0" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data"><xsl:import href="../../../../number.xsl"></xsl:import><xsl:import href="../../../../date.xsl"></xsl:import><xsl:import href="../../../../table.xsl"></xsl:import><xsl:import href="../../../../style.xsl"></xsl:import><xsl:import href="../../../../lien.xsl"></xsl:import><xsl:param name="HTML_OUTPUT_FORMAT"></xsl:param><xsl:param name="PDF_OUTPUT_FORMAT"></xsl:param><xsl:variable name="page-format" select="portrait"></xsl:variable><xsl:output encoding="UTF-8" method="xml" indent="yes"></xsl:output><xsl:variable name="docbudg" select="/EtatRAR"></xsl:variable><xsl:param name="nomenclaturePasEnrichie"></xsl:param><xsl:variable name="nomenclature" select="$nomenclaturePasEnrichie/n:Nomenclature"></xsl:variable><xsl:variable name="data" select="document('../../libelleAffiche.xml')/data"></xsl:variable><xsl:variable name="isPrint" select="1"></xsl:variable><xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"></xsl:decimal-format><xsl:template match="*"></xsl:template><xsl:template match="EtatRAR"><html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
   <head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" /><meta name="generator" content="ODM" />
      
      <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css" />
      <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css" />
      
      <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:SimSun;
  panose-1:2 1 6 0 3 1 1 1 1 1;}
@font-face
  {font-family:Mangal;
  panose-1:0 0 4 0 0 0 0 0 0 0;}
@font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:"Liberation Serif";
  panose-1:2 2 6 3 5 4 5 2 3 4;}
@font-face
  {font-family:"\@SimSun";
  panose-1:2 1 6 0 3 1 1 1 1 1;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0cm;
  font-size:16.0pt;
  font-family:"Times New Roman",serif;}
p.TableContents, li.TableContents, div.TableContents
  {
  margin:0cm;
  text-autospace:ideograph-other;
  font-size:12.0pt;
  font-family:"Liberation Serif",serif;}
.MsoChpDefault
  {font-family:"Calibri",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
@page{size:297mm 210mm;
  }
div.WordSection1
  {}
--&gt;
/**/
}</style></head>
   <body lang="FR" style="word-wrap:break-word"><div id="header">
         <div align="center">
            <xsl:variable name="varOdmTmpTab1"><table width="100%" class="MsoNormalTable " border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse"><tr><td width="50%" valign="top" style="padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1"><p style="line-height:115%;punctuation-wrap:simple;word-break: break-all"><span style="font-size:10.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                           <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Tresorerie/@Codique)"/> - 
                           
                           
                           <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Tresorerie/@LibellePoste)"/></span></p></td><td width="50%" valign="top" style="padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1"><p align="right" style="text-align:right;line-height:115%; punctuation-wrap:simple;word-break:break-all"><span style="font-size:10.0pt; line-height:115%;font-family:&#34;Arial&#34;,sans-serif">Date édition :
                           
                           
                           <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/EnteteComptable/Infos/Edition/@DateEdition)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></p></td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab1"></xsl:with-param></xsl:call-template>
         </div>
         <p class="MsoNormal"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
         <p class="MsoNormal"> </p>
         <p class="MsoNormal"> </p>
      </div>
      
      <div class="WordSection1">
         <xsl:variable name="varOdmTmpTab2"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none"><tr><td width="100%" valign="top" style="border:none;border-bottom: solid black 1.0pt;padding:0cm 0cm 0cm 0cm" rowspan="1" colspan="1">
                  <xsl:variable name="varOdmTmpTab3"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none"><tr height="0" class="#tech# #fixWidths#"><td width="5%" style="border:none" rowspan="1" colspan="1"></td><td width="10%" style="border:none" rowspan="1" colspan="1"></td><td width="8%" style="border:none" rowspan="1" colspan="1"></td><td width="5%" style="border:none" rowspan="1" colspan="1"></td><td width="15%" style="border:none" rowspan="1" colspan="1"></td><td width="15%" style="border:none" rowspan="1" colspan="1"></td><td width="8%" style="border:none" rowspan="1" colspan="1"></td><td width="8%" style="border:none" rowspan="1" colspan="1"></td><td width="8%" style="border:none" rowspan="1" colspan="1"></td><td width="18%" style="border:none" rowspan="1" colspan="1"></td></tr><xsl:for-each select="$docbudg/Budget/Compte/@NumOrdre"><xsl:sort>.</xsl:sort><xsl:variable name="codeBoucleBloc_DRAR_BU_CPT_NumOrdreTxt_0" select="."></xsl:variable><xsl:variable name="blocLignes_DRAR_BU_CPT_NumOrdreTxt_0" select="$docbudg/Budget/Compte[(./@NumOrdre=$codeBoucleBloc_DRAR_BU_CPT_NumOrdreTxt_0)]"/><xsl:if test="$blocLignes_DRAR_BU_CPT_NumOrdreTxt_0"><tr xmlns:odm="http://www.axyus.com/2010/odm"><xsl:variable name="varOdm1" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:LigneBudget"/><xsl:variable name="content1">
                           <b><span></span></b>
                        </xsl:variable><xsl:variable name="className1">VIDE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className1" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">10</xsl:with-param><xsl:with-param name="width">18%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content1" /></xsl:call-template></tr><xsl:for-each select="$blocLignes_DRAR_BU_CPT_NumOrdreTxt_0/Service/@NumOrdre"><xsl:sort>.</xsl:sort><xsl:variable name="codeBoucleBloc_DRAR_BU_CPT_Se_NumOrdreTxt_0" select="."></xsl:variable><xsl:variable name="blocLignes_DRAR_BU_CPT_Se_NumOrdreTxt_0" select="$blocLignes_DRAR_BU_CPT_NumOrdreTxt_0/Service[(./@NumOrdre=$codeBoucleBloc_DRAR_BU_CPT_Se_NumOrdreTxt_0)]"/><xsl:if test="$blocLignes_DRAR_BU_CPT_Se_NumOrdreTxt_0"><tr xmlns:odm="http://www.axyus.com/2010/odm"><xsl:variable name="varOdm2" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:LigneBudget"/><xsl:variable name="content2">
                           <b><span> </span></b>
                        </xsl:variable><xsl:variable name="className2">VIDE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className2" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">10</xsl:with-param><xsl:with-param name="width">18%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content2" /></xsl:call-template></tr><tr xmlns:odm="http://www.axyus.com/2010/odm" class="PAGE_BREAK"><xsl:variable name="varOdm3" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:LigneBudget"/><td width="18%" colspan="10" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p align="center" style="text-align:center"><b><span style="font-family:&#34;Arial&#34;,sans-serif"></span></b><b><span style="font-family:&#34;Arial&#34;,sans-serif">État des Restes à Recouvrer sur pièces prises en charge du 01/01 au</span></b><b><span style="font-size: 12.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></b><b><span style="font-family:&#34;Arial&#34;,sans-serif"><xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($blocLignes_DRAR_BU_CPT_NumOrdreTxt_0[(./Service/@NumOrdre=$codeBoucleBloc_DRAR_BU_CPT_Se_NumOrdreTxt_0)]/@DateFin)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></b></p></td></tr><tr xmlns:odm="http://www.axyus.com/2010/odm"><td width="18%" colspan="10" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p align="center" style="text-align:center"><span style="font-size:10.0pt;font-family:&#34;Arial&#34;,sans-serif">Situation actualisée au <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($blocLignes_DRAR_BU_CPT_NumOrdreTxt_0[(./Service/@NumOrdre=$codeBoucleBloc_DRAR_BU_CPT_Se_NumOrdreTxt_0)]/@DateSituation)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></p></td></tr><tr xmlns:odm="http://www.axyus.com/2010/odm"><td width="18%" colspan="10" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p align="center" style="text-align:center"><b><span style="font-family:&#34;Arial&#34;,sans-serif">Compte <xsl:value-of select="distinct-values($blocLignes_DRAR_BU_CPT_NumOrdreTxt_0[(./Service/@NumOrdre=$codeBoucleBloc_DRAR_BU_CPT_Se_NumOrdreTxt_0)]/@NumCompte)"/></span></b></p></td></tr><tr xmlns:odm="http://www.axyus.com/2010/odm"><td width="18%" colspan="10" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p align="center" style="text-align:center"><span style="font-family:&#34;Arial&#34;,sans-serif">Service <xsl:value-of select="distinct-values($blocLignes_DRAR_BU_CPT_Se_NumOrdreTxt_0/@Service)"/></span></p></td></tr><tr xmlns:odm="http://www.axyus.com/2010/odm"><td width="15%" colspan="5" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p><span style="font-size:8.0pt"><xsl:value-of select="distinct-values($docbudg[(./Budget/Compte/@NumOrdre=$codeBoucleBloc_DRAR_BU_CPT_NumOrdreTxt_0) and (./Budget/Compte/Service/@NumOrdre=$codeBoucleBloc_DRAR_BU_CPT_Se_NumOrdreTxt_0)]/EnteteComptable/Infos/Collectivite/@CodeBC)"/> - <xsl:value-of select="distinct-values($docbudg[(./Budget/Compte/@NumOrdre=$codeBoucleBloc_DRAR_BU_CPT_NumOrdreTxt_0) and (./Budget/Compte/Service/@NumOrdre=$codeBoucleBloc_DRAR_BU_CPT_Se_NumOrdreTxt_0)]/EnteteComptable/Infos/Collectivite/@Libelle)"/></span></p></td><td width="18%" colspan="5" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Exercice : <xsl:value-of select="distinct-values($docbudg[(./Budget/Compte/@NumOrdre=$codeBoucleBloc_DRAR_BU_CPT_NumOrdreTxt_0) and (./Budget/Compte/Service/@NumOrdre=$codeBoucleBloc_DRAR_BU_CPT_Se_NumOrdreTxt_0)]/EnteteComptable/Infos/Exercice/@V)"/></span></p></td></tr><xsl:choose><xsl:when test="$docbudg/EnteteComptable/Infos/Collectivite/@TypeBC = 'BA' or $docbudg/EnteteComptable/Infos/Collectivite/@TypeBC = 'BR'"><xsl:variable name="varOdm4" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:LigneBudget"/><tr xmlns:odm="http://www.axyus.com/2010/odm"><td width="18%" colspan="10" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p><span style="font-size:8.0pt">BA de <xsl:value-of select="distinct-values($docbudg[(./Budget/Compte/@NumOrdre=$codeBoucleBloc_DRAR_BU_CPT_NumOrdreTxt_0) and (./Budget/Compte/Service/@NumOrdre=$codeBoucleBloc_DRAR_BU_CPT_Se_NumOrdreTxt_0)]/EnteteComptable/Infos/BudgetRattachement/@Libelle)"/></span></p></td></tr></xsl:when><xsl:otherwise><tr xmlns:odm="http://www.axyus.com/2010/odm" class=" #tech#"><td height="1px" width="15%" colspan="5" valign="top" rowspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="18%" colspan="5" valign="top" rowspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td></tr></xsl:otherwise></xsl:choose><tr xmlns:odm="http://www.axyus.com/2010/odm"><xsl:variable name="varOdm5" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:LigneBudget"/><xsl:variable name="content3">
                           <span></span>
                        </xsl:variable><xsl:variable name="className3">LIGNE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className3" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">10</xsl:with-param><xsl:with-param name="width">18%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content3" /></xsl:call-template></tr><tr xmlns:odm="http://www.axyus.com/2010/odm"><td width="5%" style="border:solid black 1.0pt;border-top: none;padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Exercice</span></b></p>
                        </td><td width="10%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">No pièce</span></b></p>
                        </td><td width="8%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Date PEC</span></b></p>
                        </td><td width="5%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">No ligne</span></b></p>
                        </td><td width="15%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Nom du débiteur</span></b></p>
                        </td><td width="15%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Objet du titre</span></b></p>
                        </td><td width="8%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Montant principal</span></b></p>
                        </td><td width="8%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Montant des frais de poursuite</span></b></p>
                        </td><td width="8%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Reste à recouvrer</span></b></p>
                        </td><td width="18%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Diligence exercée</span></b></p>
                        </td></tr><xsl:for-each select="$blocLignes_DRAR_BU_CPT_Se_NumOrdreTxt_0/ExerciceCompte/@NumOrdre"><xsl:sort>.</xsl:sort><xsl:variable name="codeBoucleBloc_DRAR_BU_CPT_Se_EC_NumOrdreTxt_0" select="."></xsl:variable><xsl:variable name="blocLignes_DRAR_BU_CPT_Se_EC_NumOrdreTxt_0" select="$blocLignes_DRAR_BU_CPT_Se_NumOrdreTxt_0/ExerciceCompte[(./@NumOrdre=$codeBoucleBloc_DRAR_BU_CPT_Se_EC_NumOrdreTxt_0)]"/><xsl:if test="$blocLignes_DRAR_BU_CPT_Se_EC_NumOrdreTxt_0"><tr xmlns:odm="http://www.axyus.com/2010/odm"><xsl:variable name="varOdm6" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:LigneBudget"/><xsl:variable name="content4">
                           <b><span></span></b>
                        </xsl:variable><xsl:variable name="className4">VIDE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className4" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">5%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content4" /></xsl:call-template><xsl:variable name="content5"> </xsl:variable><xsl:variable name="className5">VIDE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className5" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">10%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content5" /></xsl:call-template><xsl:variable name="content6"> </xsl:variable><xsl:variable name="className6">VIDE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className6" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content6" /></xsl:call-template><xsl:variable name="content7"> </xsl:variable><xsl:variable name="className7">VIDE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className7" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">5%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content7" /></xsl:call-template><xsl:variable name="content8"> </xsl:variable><xsl:variable name="className8">VIDE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className8" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">15%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content8" /></xsl:call-template><xsl:variable name="content9"> </xsl:variable><xsl:variable name="className9">VIDE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className9" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">15%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content9" /></xsl:call-template><xsl:variable name="content10"> </xsl:variable><xsl:variable name="className10">VIDE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className10" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content10" /></xsl:call-template><xsl:variable name="content11"> </xsl:variable><xsl:variable name="className11">VIDE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className11" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content11" /></xsl:call-template><xsl:variable name="content12"> </xsl:variable><xsl:variable name="className12">VIDE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className12" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content12" /></xsl:call-template><xsl:variable name="content13"> </xsl:variable><xsl:variable name="className13">VIDE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className13" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">18%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content13" /></xsl:call-template></tr><xsl:variable name="varOdm7" select="$blocLignes_DRAR_BU_CPT_Se_EC_NumOrdreTxt_0/LigneRAR"/><xsl:variable name="varOdm8"><xsl:for-each select="$varOdm7"><xsl:sort select="./@NumOrdre" data-type="number"/><xsl:variable name="ligne" select="."/><tr xmlns:odm="http://www.axyus.com/2010/odm"><xsl:variable name="content14"><xsl:value-of select="distinct-values($blocLignes_DRAR_BU_CPT_Se_EC_NumOrdreTxt_0/@ExerciceCompte)"/></xsl:variable><xsl:variable name="className14" select="$ligne/@Format"/><xsl:variable name="className15">LIBELLE</xsl:variable><xsl:variable name="className16">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className14, ' ', $className15, ' ', $className16)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">5%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content14" /></xsl:call-template><xsl:variable name="content15"><xsl:value-of select="distinct-values($ligne/@NumPiece)"/></xsl:variable><xsl:variable name="className17" select="$ligne/@Format"/><xsl:variable name="className18">LIBELLE</xsl:variable><xsl:variable name="className19">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className17, ' ', $className18, ' ', $className19)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">10%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content15" /></xsl:call-template><xsl:variable name="content16"><xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($ligne/@DatePEC)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></xsl:variable><xsl:variable name="className20" select="$ligne/@Format"/><xsl:variable name="className21">LIBELLE</xsl:variable><xsl:variable name="className22">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className20, ' ', $className21, ' ', $className22)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content16" /></xsl:call-template><xsl:variable name="content17"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/@NumLigne"/></xsl:call-template></xsl:variable><xsl:variable name="className23" select="$ligne/@Format"/><xsl:variable name="className24">LIBELLE</xsl:variable><xsl:variable name="className25">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className23, ' ', $className24, ' ', $className25)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">5%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content17" /></xsl:call-template><xsl:variable name="content18"><xsl:value-of select="distinct-values($ligne/@Tiers)"/></xsl:variable><xsl:variable name="className26" select="$ligne/@Format"/><xsl:variable name="className27">LIBELLE</xsl:variable><xsl:variable name="className28">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className26, ' ', $className27, ' ', $className28)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">15%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content18" /></xsl:call-template><xsl:variable name="content19"><xsl:value-of select="distinct-values($ligne/@ObjetPiece)"/></xsl:variable><xsl:variable name="className29" select="$ligne/@Format"/><xsl:variable name="className30">LIBELLE</xsl:variable><xsl:variable name="className31">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className29, ' ', $className30, ' ', $className31)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">15%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content19" /></xsl:call-template><xsl:variable name="content20"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/@MontantPiece"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className32" select="$ligne/@Format"/><xsl:variable name="className33">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className32, ' ', $className33)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content20" /></xsl:call-template><xsl:variable name="content21"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/@MontantFrais"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className34" select="$ligne/@Format"/><xsl:variable name="className35">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className34, ' ', $className35)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content21" /></xsl:call-template><xsl:variable name="content22"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/@MontantRAR"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className36" select="$ligne/@Format"/><xsl:variable name="className37">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className36, ' ', $className37)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content22" /></xsl:call-template><xsl:variable name="content23"><xsl:for-each select="$ligne/Diligence/@Diligence"><xsl:sort>$ligne/Diligence/@NumOrdre</xsl:sort><xsl:variable name="codeBoucleBloc_DRAR_BU_CPT_Se_EC_LRAR_Di_Diligence_10" select="."></xsl:variable><xsl:variable name="blocLignes_DRAR_BU_CPT_Se_EC_LRAR_Di_Diligence_10" select="$ligne/Diligence[(./@Diligence=$codeBoucleBloc_DRAR_BU_CPT_Se_EC_LRAR_Di_Diligence_10)]"/><xsl:if test="$blocLignes_DRAR_BU_CPT_Se_EC_LRAR_Di_Diligence_10"><xsl:value-of select="distinct-values($codeBoucleBloc_DRAR_BU_CPT_Se_EC_LRAR_Di_Diligence_10)"/><br /></xsl:if></xsl:for-each></xsl:variable><xsl:variable name="className38" select="$ligne/@Format"/><xsl:variable name="className39">DECIMAL</xsl:variable><xsl:variable name="className40">RBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className38, ' ', $className39, ' ', $className40)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">18%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content23" /></xsl:call-template></tr></xsl:for-each></xsl:variable><xsl:variable name="varOdm9"><xsl:choose><xsl:when test="count($varOdm8/*) = 0"><tr xmlns:odm="http://www.axyus.com/2010/odm" class=" #tech#"><td height="1px" width="5%" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;; border-top:hidden; border-bottom:padding: 0cm 0cm 1.5pt 0cm;  border-left:none; border-right:none"></td><td height="1px" width="10%" rowspan="1" colspan="1" style="padding:0cm 0cm 0cm 0cm; border-top:hidden; border-bottom:padding: 0cm 0cm 1.5pt 0cm;  border-left:none; border-right:none"></td><td height="1px" width="8%" rowspan="1" colspan="1" style="padding:0cm 0cm 0cm 0cm; border-top:hidden; border-bottom:padding: 0cm 0cm 1.5pt 0cm;  border-left:none; border-right:none"></td><td height="1px" width="5%" rowspan="1" colspan="1" style="padding:0cm 0cm 0cm 0cm; border-top:hidden; border-bottom:padding: 0cm 0cm 1.5pt 0cm;  border-left:none; border-right:none"></td><td height="1px" width="15%" rowspan="1" colspan="1" style="padding:0cm 0cm 0cm 0cm; border-top:hidden; border-bottom:padding: 0cm 0cm 1.5pt 0cm;  border-left:none; border-right:none"></td><td height="1px" width="15%" rowspan="1" colspan="1" style="padding:0cm 0cm 0cm 0cm; border-top:hidden; border-bottom:padding: 0cm 0cm 1.5pt 0cm;  border-left:none; border-right:none"></td><td height="1px" width="8%" rowspan="1" colspan="1" style="padding:0cm 0cm 0cm 0cm; border-top:hidden; border-bottom:padding: 0cm 0cm 1.5pt 0cm;  border-left:none; border-right:none"></td><td height="1px" width="8%" rowspan="1" colspan="1" style="padding:0cm 0cm 0cm 0cm; border-top:hidden; border-bottom:padding: 0cm 0cm 1.5pt 0cm;  border-left:none; border-right:none"></td><td height="1px" width="8%" rowspan="1" colspan="1" style="padding:0cm 0cm 0cm 0cm; border-top:hidden; border-bottom:padding: 0cm 0cm 1.5pt 0cm;  border-left:none; border-right:none"></td><td height="1px" width="18%" rowspan="1" colspan="1" style="padding:0cm 0cm 0cm 0cm; border-top:hidden; border-bottom:padding: 0cm 0cm 1.5pt 0cm;  border-left:none; border-right:none"></td></tr></xsl:when><xsl:otherwise><xsl:sequence select="$varOdm8"></xsl:sequence></xsl:otherwise></xsl:choose></xsl:variable><xsl:call-template name="table:processRowStyled"><xsl:with-param name="borderStyle" select="'solid 1.0pt'"></xsl:with-param><xsl:with-param name="rows" select="$varOdm9/xhtml:tr"></xsl:with-param></xsl:call-template><tr xmlns:odm="http://www.axyus.com/2010/odm"><xsl:variable name="varOdm10" select="$blocLignes_DRAR_BU_CPT_Se_EC_NumOrdreTxt_0/LigneRAR"/><xsl:variable name="content24">Sous-total de l’exercice <xsl:value-of select="distinct-values($blocLignes_DRAR_BU_CPT_Se_EC_NumOrdreTxt_0/TotalExercice/@Libelle)"/></xsl:variable><xsl:variable name="className41" select="$blocLignes_DRAR_BU_CPT_Se_EC_NumOrdreTxt_0/TotalExercice/@Format"/><xsl:variable name="className42">LIBELLE</xsl:variable><xsl:variable name="className43">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className41, ' ', $className42, ' ', $className43)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">6</xsl:with-param><xsl:with-param name="width">15%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content24" /></xsl:call-template><xsl:variable name="content25"> <xsl:call-template name="num:number"><xsl:with-param name="num" select="$blocLignes_DRAR_BU_CPT_Se_EC_NumOrdreTxt_0/TotalExercice/@Montant"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className44" select="$blocLignes_DRAR_BU_CPT_Se_EC_NumOrdreTxt_0/TotalExercice/@Format"/><xsl:variable name="className45">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className44, ' ', $className45)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content25" /></xsl:call-template><xsl:variable name="content26"> <xsl:call-template name="num:number"><xsl:with-param name="num" select="$blocLignes_DRAR_BU_CPT_Se_EC_NumOrdreTxt_0/TotalExercice/@MontantFrais"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className46" select="$blocLignes_DRAR_BU_CPT_Se_EC_NumOrdreTxt_0/TotalExercice/@Format"/><xsl:variable name="className47">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className46, ' ', $className47)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content26" /></xsl:call-template><xsl:variable name="content27"> <xsl:call-template name="num:number"><xsl:with-param name="num" select="$blocLignes_DRAR_BU_CPT_Se_EC_NumOrdreTxt_0/TotalExercice/@MontantRAR"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className48" select="$blocLignes_DRAR_BU_CPT_Se_EC_NumOrdreTxt_0/TotalExercice/@Format"/><xsl:variable name="className49">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className48, ' ', $className49)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content27" /></xsl:call-template><xsl:variable name="content28">
                           <span></span>
                        </xsl:variable><xsl:variable name="className50" select="$blocLignes_DRAR_BU_CPT_Se_EC_NumOrdreTxt_0/TotalExercice/@Format"/><xsl:variable name="className51">DECIMAL</xsl:variable><xsl:variable name="className52">RBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className50, ' ', $className51, ' ', $className52)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">18%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content28" /></xsl:call-template></tr></xsl:if></xsl:for-each><tr xmlns:odm="http://www.axyus.com/2010/odm" class="PAGE_BREAK"><xsl:variable name="varOdm11" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:LigneBudget"/><td width="18%" colspan="10" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p align="center" style="text-align:center"><b><span style="font-family:&#34;Arial&#34;,sans-serif"></span></b><b><span style="font-family:&#34;Arial&#34;,sans-serif">État des Restes à Recouvrer sur pièces prises en charge du 01/01 au</span></b><b><span style="font-size: 12.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></b><b><span style="font-family:&#34;Arial&#34;,sans-serif"><xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($blocLignes_DRAR_BU_CPT_NumOrdreTxt_0[(./Service/@NumOrdre=$codeBoucleBloc_DRAR_BU_CPT_Se_NumOrdreTxt_0)]/@DateFin)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></b></p></td></tr><tr xmlns:odm="http://www.axyus.com/2010/odm"><td width="18%" colspan="10" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p align="center" style="text-align:center"><span style="font-size:10.0pt;font-family:&#34;Arial&#34;,sans-serif">Situation actualisée au <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($blocLignes_DRAR_BU_CPT_NumOrdreTxt_0[(./Service/@NumOrdre=$codeBoucleBloc_DRAR_BU_CPT_Se_NumOrdreTxt_0)]/@DateSituation)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></p></td></tr><tr xmlns:odm="http://www.axyus.com/2010/odm"><td width="18%" colspan="10" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p align="center" style="text-align:center"><b><span style="font-family:&#34;Arial&#34;,sans-serif">Compte <xsl:value-of select="distinct-values($blocLignes_DRAR_BU_CPT_NumOrdreTxt_0[(./Service/@NumOrdre=$codeBoucleBloc_DRAR_BU_CPT_Se_NumOrdreTxt_0)]/@NumCompte)"/></span></b></p></td></tr><tr xmlns:odm="http://www.axyus.com/2010/odm"><td width="18%" colspan="10" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p align="center" style="text-align:center"><span style="font-family:&#34;Arial&#34;,sans-serif">Service <xsl:value-of select="distinct-values($blocLignes_DRAR_BU_CPT_Se_NumOrdreTxt_0/@Service)"/></span></p></td></tr><tr xmlns:odm="http://www.axyus.com/2010/odm"><td width="15%" colspan="5" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p><span style="font-size:8.0pt"><xsl:value-of select="distinct-values($docbudg[(./Budget/Compte/@NumOrdre=$codeBoucleBloc_DRAR_BU_CPT_NumOrdreTxt_0) and (./Budget/Compte/Service/@NumOrdre=$codeBoucleBloc_DRAR_BU_CPT_Se_NumOrdreTxt_0)]/EnteteComptable/Infos/Collectivite/@CodeBC)"/> - <xsl:value-of select="distinct-values($docbudg[(./Budget/Compte/@NumOrdre=$codeBoucleBloc_DRAR_BU_CPT_NumOrdreTxt_0) and (./Budget/Compte/Service/@NumOrdre=$codeBoucleBloc_DRAR_BU_CPT_Se_NumOrdreTxt_0)]/EnteteComptable/Infos/Collectivite/@Libelle)"/></span></p></td><td width="18%" colspan="5" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Exercice : <xsl:value-of select="distinct-values($docbudg[(./Budget/Compte/@NumOrdre=$codeBoucleBloc_DRAR_BU_CPT_NumOrdreTxt_0) and (./Budget/Compte/Service/@NumOrdre=$codeBoucleBloc_DRAR_BU_CPT_Se_NumOrdreTxt_0)]/EnteteComptable/Infos/Exercice/@V)"/></span></p></td></tr><xsl:choose><xsl:when test="$docbudg/EnteteComptable/Infos/Collectivite/@TypeBC = 'BA' or $docbudg/EnteteComptable/Infos/Collectivite/@TypeBC = 'BR'"><xsl:variable name="varOdm12" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:LigneBudget"/><tr xmlns:odm="http://www.axyus.com/2010/odm"><td width="18%" colspan="10" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1"><p><span style="font-size:8.0pt">BA de <xsl:value-of select="distinct-values($docbudg[(./Budget/Compte/@NumOrdre=$codeBoucleBloc_DRAR_BU_CPT_NumOrdreTxt_0) and (./Budget/Compte/Service/@NumOrdre=$codeBoucleBloc_DRAR_BU_CPT_Se_NumOrdreTxt_0)]/EnteteComptable/Infos/BudgetRattachement/@Libelle)"/></span></p></td></tr></xsl:when><xsl:otherwise><tr xmlns:odm="http://www.axyus.com/2010/odm" class=" #tech#"><td height="1px" width="15%" colspan="5" valign="top" rowspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="18%" colspan="5" valign="top" rowspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td></tr></xsl:otherwise></xsl:choose><tr xmlns:odm="http://www.axyus.com/2010/odm"><xsl:variable name="varOdm13" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:LigneBudget"/><xsl:variable name="content29">
                           <span></span>
                        </xsl:variable><xsl:variable name="className53">LIGNE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className53" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">10</xsl:with-param><xsl:with-param name="width">18%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content29" /></xsl:call-template></tr><tr xmlns:odm="http://www.axyus.com/2010/odm"><td width="5%" style="border:solid black 1.0pt;border-top: none;padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Exercice</span></b></p>
                        </td><td width="10%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">No pièce</span></b></p>
                        </td><td width="8%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Date PEC</span></b></p>
                        </td><td width="5%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">No ligne</span></b></p>
                        </td><td width="15%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Nom du débiteur</span></b></p>
                        </td><td width="15%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Objet du titre</span></b></p>
                        </td><td width="8%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Montant principal</span></b></p>
                        </td><td width="8%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Montant des frais de poursuite</span></b></p>
                        </td><td width="8%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Reste à recouvrer</span></b></p>
                        </td><td width="18%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="TableContents" align="center" style="text-align:center"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Diligence exercée</span></b></p>
                        </td></tr><tr xmlns:odm="http://www.axyus.com/2010/odm"><xsl:variable name="varOdm14" select="$blocLignes_DRAR_BU_CPT_Se_NumOrdreTxt_0/ExerciceCompte/LigneRAR"/><xsl:variable name="content30">Total du service <xsl:value-of select="distinct-values($blocLignes_DRAR_BU_CPT_Se_NumOrdreTxt_0/TotalService/@Libelle)"/></xsl:variable><xsl:variable name="className54" select="$blocLignes_DRAR_BU_CPT_Se_NumOrdreTxt_0/TotalService/@Format"/><xsl:variable name="className55">LIBELLE</xsl:variable><xsl:variable name="className56">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className54, ' ', $className55, ' ', $className56)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">6</xsl:with-param><xsl:with-param name="width">15%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content30" /></xsl:call-template><xsl:variable name="content31"> <xsl:call-template name="num:number"><xsl:with-param name="num" select="$blocLignes_DRAR_BU_CPT_Se_NumOrdreTxt_0/TotalService/@Montant"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className57" select="$blocLignes_DRAR_BU_CPT_Se_NumOrdreTxt_0/TotalService/@Format"/><xsl:variable name="className58">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className57, ' ', $className58)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content31" /></xsl:call-template><xsl:variable name="content32"> <xsl:call-template name="num:number"><xsl:with-param name="num" select="$blocLignes_DRAR_BU_CPT_Se_NumOrdreTxt_0/TotalService/@MontantFrais"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className59" select="$blocLignes_DRAR_BU_CPT_Se_NumOrdreTxt_0/TotalService/@Format"/><xsl:variable name="className60">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className59, ' ', $className60)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content32" /></xsl:call-template><xsl:variable name="content33"> <xsl:call-template name="num:number"><xsl:with-param name="num" select="$blocLignes_DRAR_BU_CPT_Se_NumOrdreTxt_0/TotalService/@MontantRAR"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className61" select="$blocLignes_DRAR_BU_CPT_Se_NumOrdreTxt_0/TotalService/@Format"/><xsl:variable name="className62">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className61, ' ', $className62)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content33" /></xsl:call-template><xsl:variable name="content34">
                           <span></span>
                        </xsl:variable><xsl:variable name="className63" select="$blocLignes_DRAR_BU_CPT_Se_NumOrdreTxt_0/TotalService/@Format"/><xsl:variable name="className64">DECIMAL</xsl:variable><xsl:variable name="className65">RBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className63, ' ', $className64, ' ', $className65)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">18%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content34" /></xsl:call-template></tr></xsl:if></xsl:for-each><tr xmlns:odm="http://www.axyus.com/2010/odm"><xsl:variable name="varOdm15" select="$blocLignes_DRAR_BU_CPT_NumOrdreTxt_0/Service/ExerciceCompte/LigneRAR"/><xsl:variable name="content35">
                           <b><span></span></b><b><span>TOTAL DU COMPTE</span></b>
                        </xsl:variable><xsl:variable name="className66" select="$blocLignes_DRAR_BU_CPT_NumOrdreTxt_0/TotalCompte/@Format"/><xsl:variable name="className67">LIBELLE</xsl:variable><xsl:variable name="className68">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className66, ' ', $className67, ' ', $className68)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">6</xsl:with-param><xsl:with-param name="width">15%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content35" /></xsl:call-template><xsl:variable name="content36"> <xsl:call-template name="num:number"><xsl:with-param name="num" select="$blocLignes_DRAR_BU_CPT_NumOrdreTxt_0/TotalCompte/@Montant"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className69" select="$blocLignes_DRAR_BU_CPT_NumOrdreTxt_0/TotalCompte/@Format"/><xsl:variable name="className70">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className69, ' ', $className70)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content36" /></xsl:call-template><xsl:variable name="content37"> <xsl:call-template name="num:number"><xsl:with-param name="num" select="$blocLignes_DRAR_BU_CPT_NumOrdreTxt_0/TotalCompte/@MontantFrais"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className71" select="$blocLignes_DRAR_BU_CPT_NumOrdreTxt_0/TotalCompte/@Format"/><xsl:variable name="className72">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className71, ' ', $className72)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content37" /></xsl:call-template><xsl:variable name="content38"> <xsl:call-template name="num:number"><xsl:with-param name="num" select="$blocLignes_DRAR_BU_CPT_NumOrdreTxt_0/TotalCompte/@MontantRAR"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className73" select="$blocLignes_DRAR_BU_CPT_NumOrdreTxt_0/TotalCompte/@Format"/><xsl:variable name="className74">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className73, ' ', $className74)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content38" /></xsl:call-template><xsl:variable name="content39">
                           <span></span>
                        </xsl:variable><xsl:variable name="className75" select="$blocLignes_DRAR_BU_CPT_NumOrdreTxt_0/TotalCompte/@Format"/><xsl:variable name="className76">DECIMAL</xsl:variable><xsl:variable name="className77">RBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className75, ' ', $className76, ' ', $className77)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">18%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content39" /></xsl:call-template></tr></xsl:if></xsl:for-each><tr><xsl:variable name="varOdm16" select="$docbudg/Budget/Compte/Service/ExerciceCompte/LigneRAR"/><xsl:variable name="content40">
                           <b><span lang="EN-US">TOTAL GENERAL</span></b>
                        </xsl:variable><xsl:variable name="className78" select="$docbudg/Budget/TotalGeneral/@Format"/><xsl:variable name="className79">LIBELLE</xsl:variable><xsl:variable name="className80">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className78, ' ', $className79, ' ', $className80)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">6</xsl:with-param><xsl:with-param name="width">15%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content40" /></xsl:call-template><xsl:variable name="content41"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/Budget/TotalGeneral/@Montant"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className81" select="$docbudg/Budget/TotalGeneral/@Format"/><xsl:variable name="className82">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className81, ' ', $className82)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content41" /></xsl:call-template><xsl:variable name="content42"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/Budget/TotalGeneral/@MontantFrais"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className83" select="$docbudg/Budget/TotalGeneral/@Format"/><xsl:variable name="className84">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className83, ' ', $className84)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content42" /></xsl:call-template><xsl:variable name="content43"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/Budget/TotalGeneral/@MontantRAR"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:variable name="className85" select="$docbudg/Budget/TotalGeneral/@Format"/><xsl:variable name="className86">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className85, ' ', $className86)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content43" /></xsl:call-template><xsl:variable name="content44"> </xsl:variable><xsl:variable name="className87" select="$docbudg/Budget/TotalGeneral/@Format"/><xsl:variable name="className88">LIBELLE</xsl:variable><xsl:variable name="className89">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className87, ' ', $className88, ' ', $className89)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">18%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content44" /></xsl:call-template></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab3"></xsl:with-param></xsl:call-template>
               </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab2"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"><span lang="EN-US"> </span></p>
      </div>
   </body><script type="text/javascript">
            function iframeLoadPage(href) {
            try {
            parent.loadPage(href);
            } catch(ex) {
            //si on n'arrive pas a acceder a la page parente
            document.location.href = href;
            }
            }
            function scrollToElementId(elementId) {
            document.getElementById(elementId).scrollIntoView();
            }
        </script>
</html></xsl:template></xsl:stylesheet>